local MakePlayerCharacter = require "prefabs/player_common"

local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
    -- 只保留这一行，其他动画文件游戏已经内置
    Asset("ANIM", "anim/niaoniao.zip"),
}


-- 角色属性
TUNING.niaoniao_HEALTH = 150    -- 生命值
TUNING.niaoniao_HUNGER = 150    -- 饥饿值
TUNING.niaoniao_SANITY = 100    -- 精神值

-- 初始物品
TUNING.GAMEMODE_STARTING_ITEMS.DEFAULT.niaoniao = {

}

local start_inv = {}
for k, v in pairs(TUNING.GAMEMODE_STARTING_ITEMS) do
    start_inv[string.lower(k)] = v.niaoniao
end
local prefabs = FlattenTree(start_inv, true)

-- 当角色从幽灵状态复活时
local function onbecamehuman(inst)
    inst.components.locomotor:SetExternalSpeedMultiplier(inst, "niaoniao_speed_mod", 1)
end

-- 当角色变成幽灵时
local function onbecameghost(inst)
    inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "niaoniao_speed_mod")
end

-- 当加载或生成角色时
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end

-- 客户端和服务端都会初始化的部分
local common_postinit = function(inst) 
    -- 小地图图标
    inst.MiniMapEntity:SetIcon("niaoniao.tex")
    
    -- 添加快速采集标签
    inst:AddTag("fastpicker")
    
    -- 使用威尔逊的动画
    inst.animname = "niaoniao"
end

-- 仅服务端初始化的部分
local master_postinit = function(inst)
        -- 添加建造者标签（在这里添加）
    inst:AddTag("niaoniao")

    -- 设置初始物品
    inst.starting_inventory = start_inv[TheNet:GetServerGameMode()] or start_inv.default
    
    -- 使用威尔逊的音效
    inst.soundsname = "wilson"
    
    -- 属性设置
    inst.components.health:SetMaxHealth(TUNING.niaoniao_HEALTH)
    inst.components.hunger:SetMax(TUNING.niaoniao_HUNGER)
    inst.components.sanity:SetMax(TUNING.niaoniao_SANITY)
    
    -- 伤害倍率
    inst.components.combat.damagemultiplier = 1
    
    -- 饥饿速率
    inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
    
    -- 特殊能力
    inst.components.builder.buildtime_multiplier = 0.5  -- 制作时间减半
    
    -- 快速采集能力
    if not inst.components.worker then
        inst:AddComponent("worker")
    end
    inst.components.worker:SetAction(ACTIONS.PICK, 2.0)  -- 采集速度2倍
    
    -- 确保使用威尔逊的动画
    inst.animname = "niaoniao"
    
    -- 事件绑定
    inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("niaoniao", prefabs, assets, common_postinit, master_postinit)